/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.modelgen;

import ibm.nways.jdm.CompStatusDefault;
import ibm.nways.jdm.CompoundStatus;
import ibm.nways.jdm.ConfigChangeEvent;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteModelImpl;
import ibm.nways.jdm.RemoteStatusImpl;
import ibm.nways.jdm.StatusImpl;
import ibm.nways.jdm.common.AddressChangeEvent;
import ibm.nways.jdm.common.AddressChangeListener;
import ibm.nways.jdm.common.DispatchMessage;
import ibm.nways.jdm.common.DispatchQueue;
import ibm.nways.jdm.common.Disposable;
import ibm.nways.jdm.common.Mib;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.SingleInstanceFactory;
import ibm.nways.jdm.modelgen.ComponentMetadata;
import ibm.nways.jdm.modelgen.ConfigChangeDetector;
import ibm.nways.jdm.modelgen.ConfigChecker;
import ibm.nways.jdm.modelgen.CreateResponse;
import ibm.nways.jdm.modelgen.CriticalStatusScalarRequest;
import ibm.nways.jdm.modelgen.DeleteResponse;
import ibm.nways.jdm.modelgen.DisposeRequest;
import ibm.nways.jdm.modelgen.GenModelImpl;
import ibm.nways.jdm.modelgen.IndexContext;
import ibm.nways.jdm.modelgen.InfoMetadata;
import ibm.nways.jdm.modelgen.Instrumentation;
import ibm.nways.jdm.modelgen.InstrumentationContext;
import ibm.nways.jdm.modelgen.InstrumentationContextFactory;
import ibm.nways.jdm.modelgen.InstrumentationFactory;
import ibm.nways.jdm.modelgen.InvalidComponentException;
import ibm.nways.jdm.modelgen.InvalidInfoException;
import ibm.nways.jdm.modelgen.LocalComponent;
import ibm.nways.jdm.modelgen.LocalComponentStatus;
import ibm.nways.jdm.modelgen.LocalCompoundStatus;
import ibm.nways.jdm.modelgen.LocalStatus;
import ibm.nways.jdm.modelgen.LocalTableFilter;
import ibm.nways.jdm.modelgen.LocalTableStatus;
import ibm.nways.jdm.modelgen.ModelclassMetadata;
import ibm.nways.jdm.modelgen.RefreshMonitorRequest;
import ibm.nways.jdm.modelgen.RefreshTableMonitorRequest;
import ibm.nways.jdm.modelgen.SnmpInstrContext;
import ibm.nways.jdm.modelgen.SnmpInstrumentation;
import ibm.nways.jdm.modelgen.StartMonitorRequest;
import ibm.nways.jdm.modelgen.StartTableMonitorRequest;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.StatusRule;
import ibm.nways.jdm.modelgen.StopMonitorRequest;
import ibm.nways.jdm.modelgen.StopTableMonitorRequest;
import ibm.nways.jdm.modelgen.TableFilter;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.trap.ModelTrap;
import ibm.nways.jdm.trap.TrapHandler;
import ibm.nways.jdm.trap.TrapInfo;
import ibm.nways.jdm.trap.TrapService;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LocalModel
implements Disposable,
AddressChangeListener {
    public static final int NO_STATUS_FOR_ME = 0;
    public static final int STATUS_ON_SCALAR_MODEL = 1;
    public static final int STATUS_ON_ROW_OF_TABLE = 2;
    public static final int STATUS_ON_TABLE = 3;
    public static final int STATUS_ON_MY_COMPONENTS = 4;
    public static final int ROW_HAS_COMPOUND_STATUS = 5;
    private Vector trapHandlers;
    private Vector trapRules;
    private LocalModel parentModel;
    protected InstrumentationContext context;
    protected Instrumentation instr;
    protected Mib rows;
    protected IndexContext indexContext;
    protected boolean disposed;
    protected Vector schemes;
    protected OID rowID;
    protected RemoteModelImpl remoteModel;
    protected static DispatchQueue dispatchQueue = new DispatchQueue();
    protected LocalModel toplevel;
    protected LocalStatus status;
    protected int statusType;
    protected StatusModelInfo specialSMI;
    protected Hashtable components;
    protected boolean isRow;
    protected ConfigChangeDetector detector;
    protected ConfigChecker configChecker;
    protected LocalTableFilter localTableFilter;
    protected String[] localTableFilterItems;

    public LocalModel(String string, String string2) {
        Object object;
        this.parentModel = null;
        InstrumentationContextFactory instrumentationContextFactory = (InstrumentationContextFactory)JdmServerImpl.getSingleton().getService((Object)"instrumentationFactories");
        this.context = instrumentationContextFactory.getInstrumentationContext(string2);
        this.instr = InstrumentationFactory.getInstrumentation((String)string, (String)this.context.getProtocol());
        this.indexContext = null;
        this.rowID = null;
        this.remoteModel = null;
        this.toplevel = this;
        this.statusType = 0;
        this.status = null;
        this.specialSMI = null;
        this.rows = null;
        this.components = new Hashtable();
        this.isRow = false;
        this.detector = null;
        this.trapHandlers = null;
        this.trapHandlers = null;
        this.trapRules = null;
        this.configChecker = new ConfigChecker(this);
        Object object2 = this.instr.startConfigChecker(this, (Object)this.configChecker);
        this.configChecker.setCookie(object2);
        this.setupTraps();
        ModelclassMetadata modelclassMetadata = (ModelclassMetadata)this.instr.metadataPool.get("_Class_");
        if (modelclassMetadata.configChange != null) {
            object = new ConfigDetectorInitRequest(modelclassMetadata.configChange, this);
            dispatchQueue.post((DispatchMessage)object);
        }
        if (this.getContext() != null && (object = this.getContext()) instanceof SnmpInstrContext) {
            SnmpSession snmpSession = ((SnmpInstrContext)object).getSession();
            snmpSession.addAddressChangeListener((AddressChangeListener)this);
        }
    }

    public LocalModel(String string, InstrumentationContext instrumentationContext, IndexContext indexContext, LocalModel localModel) {
        Object object;
        this.parentModel = null;
        this.context = instrumentationContext;
        this.instr = InstrumentationFactory.getInstrumentation((String)string, (String)this.context.getProtocol());
        this.indexContext = indexContext;
        this.rowID = null;
        this.remoteModel = null;
        this.toplevel = localModel;
        this.status = null;
        this.components = null;
        this.isRow = false;
        this.detector = null;
        this.configChecker = null;
        this.trapHandlers = null;
        this.trapRules = null;
        ModelclassMetadata modelclassMetadata = (ModelclassMetadata)this.instr.metadataPool.get("_Class_");
        try {
            if (modelclassMetadata.tableFilterClass != null) {
                object = Class.forName(modelclassMetadata.tableFilterClass);
                this.localTableFilter = (LocalTableFilter)((Class)object).newInstance();
                this.localTableFilter.init(this);
                this.localTableFilterItems = modelclassMetadata.tableFilterItems;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.statusType = modelclassMetadata.statusSource;
        this.setupTraps();
        if (this.statusType == 3 || this.statusType == 4) {
            this.specialSMI = new StatusModelInfo(this, null, false);
        }
        if (this.statusType == 3) {
            this.rows = new Mib();
        }
        if (modelclassMetadata.configChange != null) {
            object = new ConfigDetectorInitRequest(modelclassMetadata.configChange, this);
            dispatchQueue.post((DispatchMessage)object);
        }
    }

    private LocalModel(LocalModel localModel, IndexContext indexContext, int n) {
        this.parentModel = localModel;
        this.context = localModel.getContext();
        this.instr = localModel.getInstr();
        this.indexContext = indexContext;
        this.rowID = null;
        this.remoteModel = null;
        this.toplevel = localModel.getTopLevel();
        this.statusType = n;
        this.status = null;
        this.components = null;
        this.isRow = true;
        this.detector = null;
        this.configChecker = null;
        this.trapHandlers = null;
        this.trapRules = null;
        ModelclassMetadata modelclassMetadata = (ModelclassMetadata)this.instr.metadataPool.get("_Class_");
        if (modelclassMetadata.configChange != null) {
            ConfigDetectorInitRequest configDetectorInitRequest = new ConfigDetectorInitRequest(modelclassMetadata.configChange, this);
            dispatchQueue.post(configDetectorInitRequest);
        }
        if (modelclassMetadata.rowCompound) {
            this.statusType = 5;
        }
    }

    public void setupTraps() {
        Vector vector = (Vector)this.instr.metadataPool.get("_Traps_");
        if (vector != null) {
            Object object;
            String string = "<unknown>";
            InstrumentationContext instrumentationContext = this.getContext();
            if (instrumentationContext instanceof SnmpInstrContext) {
                object = ((SnmpInstrContext)instrumentationContext).getSession();
                string = object.getPrimaryIpAddress();
            }
            this.trapHandlers = new Vector();
            this.trapRules = new Vector();
            object = (TrapService)JdmServerImpl.getSingleton().getService((Object)"TrapService");
            if (object != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        ModelTrap modelTrap = (ModelTrap)enumeration.nextElement();
                        Class<?> clazz = Class.forName(modelTrap.handler);
                        TrapHandler trapHandler = (TrapHandler)clazz.newInstance();
                        TrapInfo trapInfo = new TrapInfo(this);
                        StringBuffer stringBuffer = new StringBuffer(100);
                        stringBuffer.append("LocalModel_" + string + "_" + this.getInstrType() + "_" + this.trapRules.size());
                        StringBuffer stringBuffer2 = new StringBuffer(100);
                        stringBuffer2.append("(" + stringBuffer.toString() + " match (&enterprise == \"" + modelTrap.enterprise + "\" && &agentAddr == \"" + string + "\"");
                        if (modelTrap.generic >= 0) {
                            stringBuffer2.append(" && &genericTrap == " + modelTrap.generic);
                        }
                        if (modelTrap.specific >= 0) {
                            stringBuffer2.append(" && &specificTrap == " + modelTrap.specific);
                        }
                        stringBuffer2.append("))");
                        System.out.println("Registering local model to receive trap: " + stringBuffer2.toString());
                        ((TrapService)object).addOrReplaceRule(stringBuffer2.toString(), trapHandler, trapInfo);
                        this.trapHandlers.addElement(trapHandler);
                        this.trapRules.addElement(stringBuffer.toString());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return;
            }
            System.out.println("Unable to local trap service in local model; no trap processing enabled");
        }
    }

    public void registerForTrapsWithBackupIpAddress(String string) {
        TrapService trapService;
        Vector vector = (Vector)this.instr.metadataPool.get("_Traps_");
        if (vector != null && (trapService = (TrapService)JdmServerImpl.getSingleton().getService((Object)"TrapService")) != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ModelTrap modelTrap = (ModelTrap)enumeration.nextElement();
                    Class<?> clazz = Class.forName(modelTrap.handler);
                    TrapHandler trapHandler = (TrapHandler)clazz.newInstance();
                    TrapInfo trapInfo = new TrapInfo(this);
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append("LocalModel_" + string + "_" + this.getInstrType() + "_" + this.trapRules.size());
                    StringBuffer stringBuffer2 = new StringBuffer(100);
                    stringBuffer2.append("(" + stringBuffer.toString() + " match (&enterprise == \"" + modelTrap.enterprise + "\" && &agentAddr == \"" + string + "\"");
                    if (modelTrap.generic >= 0) {
                        stringBuffer2.append(" && &genericTrap == " + modelTrap.generic);
                    }
                    if (modelTrap.specific >= 0) {
                        stringBuffer2.append(" && &specificTrap == " + modelTrap.specific);
                    }
                    stringBuffer2.append("))");
                    trapService.addOrReplaceRule(stringBuffer2.toString(), trapHandler, trapInfo);
                    this.trapHandlers.addElement(trapHandler);
                    this.trapRules.addElement(stringBuffer.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void ipAddressChanged(AddressChangeEvent addressChangeEvent) {
        if (this.getTopLevel() != null) {
            try {
                this.getTopLevel().remoteModel.sendEvent((EventObject)new AddressChangeEvent(this, addressChangeEvent.getOldAddress(), addressChangeEvent.getNewAddress()));
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public LocalModel getTopLevel() {
        return this.toplevel;
    }

    public LocalModel getParentModel() {
        return this.parentModel;
    }

    public InstrumentationContext getContext() {
        return this.context;
    }

    public IndexContext getIndexContext() {
        return this.indexContext;
    }

    public Serializable[] getIndexes() {
        if (this.indexContext != null) {
            return this.indexContext.getValues();
        }
        return null;
    }

    public OID getIndexOID() {
        if (this.indexContext != null) {
            return this.indexContext.getOID();
        }
        return null;
    }

    public Instrumentation getInstr() {
        return this.instr;
    }

    public String getInstrType() {
        return this.instr.getClass().getName();
    }

    public Hashtable getComponents() {
        LocalModel localModel = this;
        synchronized (localModel) {
            if (this.components == null) {
                this.components = new Hashtable();
            }
        }
        return this.components;
    }

    public void checkConfig() {
        Hashtable hashtable = null;
        Object object = this;
        synchronized (object) {
            hashtable = this.components;
        }
        if (hashtable != null) {
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                LocalComponent localComponent = (LocalComponent)object.nextElement();
                localComponent.checkConfig();
            }
        }
        if (this.detector != null) {
            try {
                if (this.detector.configChanged(this)) {
                    this.sendConfigChange(this, null);
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    protected void sendConfigChange(LocalModel localModel, String string) {
        LocalModel localModel2 = localModel.toplevel;
        if (localModel2.remoteModel != null) {
            try {
                localModel2.remoteModel.sendEvent((EventObject)new ConfigChangeEvent((RemoteModel)localModel2.remoteModel, null));
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public LocalModel getComponent(String string) {
        Hashtable hashtable = this.getComponents();
        LocalModel localModel = null;
        LocalModel localModel2 = this;
        synchronized (localModel2) {
            LocalComponent localComponent = (LocalComponent)hashtable.get(string);
            if (localComponent == null) {
                ComponentMetadata componentMetadata = (ComponentMetadata)this.instr.metadataPool.get("_COMPONENT." + string);
                if (componentMetadata == null) {
                    String string2 = this.instr.getClass().getName();
                    if (string2.endsWith("SnmpInstr")) {
                        string2 = string2.substring(0, string2.length() - 9);
                    }
                    String string3 = "No COMPONENT \"" + string + "\" for CLASS " + string2;
                    InvalidComponentException invalidComponentException = new InvalidComponentException(string3);
                    throw invalidComponentException;
                }
                ModelclassMetadata modelclassMetadata = (ModelclassMetadata)this.instr.metadataPool.get("_Class_");
                if (modelclassMetadata.isVector) {
                    if (componentMetadata.appliesToRows) {
                        if (!this.isRow) {
                            String string4 = this.instr.getClass().getName();
                            if (string4.endsWith("SnmpInstr")) {
                                string4 = string4.substring(0, string4.length() - 9);
                            }
                            String string5 = "COMPONENT \"" + string + "\" for CLASS " + string4 + " applies to rows of a table, " + "not the table itself";
                            InvalidComponentException invalidComponentException = new InvalidComponentException(string5);
                            throw invalidComponentException;
                        }
                    } else if (this.isRow) {
                        String string6 = this.instr.getClass().getName();
                        if (string6.endsWith("SnmpInstr")) {
                            string6 = string6.substring(0, string6.length() - 9);
                        }
                        String string7 = "COMPONENT \"" + string + "\" for CLASS " + string6 + " applies to the table itself, " + "not its rows";
                        InvalidComponentException invalidComponentException = new InvalidComponentException(string7);
                        invalidComponentException.printStackTrace();
                        throw invalidComponentException;
                    }
                }
                localComponent = new LocalComponent(componentMetadata, this);
                hashtable.put(string, localComponent);
            }
            if ((localModel = localComponent.getModel()) != null) {
                localModel.getLocalStatus("default");
            }
        }
        return localModel;
    }

    public RemoteModel getRemoteModel() throws RemoteException {
        RemoteModelImpl remoteModelImpl = null;
        LocalModel localModel = this;
        synchronized (localModel) {
            if (this.remoteModel == null) {
                this.remoteModel = new GenModelImpl(this);
            }
            remoteModelImpl = this.remoteModel;
        }
        return remoteModelImpl;
    }

    public void setCriticalStatusForScalar(ModelInfo modelInfo, boolean bl) {
        try {
            dispatchQueue.post((DispatchMessage)new CriticalStatusScalarRequest(this, modelInfo, bl));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected void criticalStatusScalarAction(ModelInfo modelInfo, boolean bl) {
        if (this.statusType == 1) {
            ((StatusModelInfo)this.status).setCriticalScalar(modelInfo, bl);
            if (bl) {
                modelInfo.flagAsCritical();
                return;
            }
            modelInfo.flagAsNotCritical();
        }
    }

    public LocalStatus getLocalStatus(String string) {
        LocalStatus localStatus;
        block16: {
            localStatus = null;
            LocalModel localModel = this;
            synchronized (localModel) {
                block15: {
                    if (this.status != null || this.statusType == 0) break block15;
                    String string2 = this.instr.getStatusMapperClassName();
                    switch (this.statusType) {
                        case 1: 
                        case 2: {
                            StatusMapper statusMapper = (StatusMapper)SingleInstanceFactory.getInstance(string2);
                            localStatus = this.status = new StatusModelInfo(this, statusMapper, this.instr.sendStatusSpecialValues());
                            ((StatusImpl)((Object)this.status)).setName(statusMapper.nameThatObject((StatusModelInfo)this.status));
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.getSchemes();
                            int n = 0;
                            while (localStatus == null && n < this.schemes.size()) {
                                LocalCompoundStatus localCompoundStatus = (LocalCompoundStatus)this.schemes.elementAt(n);
                                if (string.equals(localCompoundStatus.getSchemeId())) {
                                    localStatus = (LocalStatus)((Object)localCompoundStatus);
                                }
                                ++n;
                            }
                            if (localStatus == null) {
                                localStatus = this.statusType == 3 ? new LocalTableStatus(this, string) : new LocalComponentStatus(this, string);
                                ((CompoundStatus)((Object)localStatus)).setManager(new CompStatusDefault());
                                Object object = SingleInstanceFactory.getInstance(string2);
                                if (object instanceof TableStatusNamer) {
                                    ((StatusImpl)((Object)localStatus)).setName(((TableStatusNamer)object).nameThatTableObject(this.specialSMI));
                                }
                                this.schemes.addElement(localStatus);
                                break;
                            }
                            break block16;
                        }
                        case 5: {
                            StatusImpl statusImpl;
                            this.getSchemes();
                            int n = 0;
                            while (localStatus == null && n < this.schemes.size()) {
                                statusImpl = (LocalCompoundStatus)this.schemes.elementAt(n);
                                if (string.equals(statusImpl.getSchemeId())) {
                                    localStatus = (LocalStatus)((Object)statusImpl);
                                }
                                ++n;
                            }
                            if (localStatus == null) {
                                localStatus = new LocalComponentStatus(this, string);
                                ((CompoundStatus)((Object)localStatus)).setManager(new CompStatusDefault());
                                StatusMapper statusMapper = (StatusMapper)SingleInstanceFactory.getInstance(string2);
                                statusImpl = new StatusModelInfo(this, statusMapper, this.instr.sendStatusSpecialValues());
                                ((StatusImpl)((Object)localStatus)).setName(statusMapper.nameThatObject((StatusModelInfo)statusImpl));
                                this.schemes.addElement(localStatus);
                                break;
                            }
                            break block16;
                        }
                        default: {
                            System.out.println("* * * Serious internal error ... not handling status type " + this.statusType);
                            break;
                        }
                    }
                    break block16;
                }
                localStatus = this.status;
            }
        }
        return localStatus;
    }

    public RemoteStatusImpl getRemoteStatusObj(String string) throws RemoteException {
        LocalStatus localStatus = this.getLocalStatus(string);
        RemoteStatusImpl remoteStatusImpl = null;
        if (localStatus != null) {
            remoteStatusImpl = localStatus.getRemoteStatusObj();
        }
        return remoteStatusImpl;
    }

    public Vector getSchemes() {
        LocalModel localModel = this;
        synchronized (localModel) {
            if (this.schemes == null) {
                this.schemes = new Vector();
            }
        }
        return this.schemes;
    }

    private InfoMetadata getInfoMetadata(String string) {
        InfoMetadata infoMetadata = (InfoMetadata)this.instr.metadataPool.get("_INFO." + string);
        if (infoMetadata == null) {
            String string2 = this.instr.getClass().getName();
            if (string2.endsWith("SnmpInstr")) {
                string2 = string2.substring(0, string2.length() - 9);
            }
            String string3 = "No INFO \"" + string + "\" for CLASS " + string2;
            throw new InvalidInfoException(string3);
        }
        return infoMetadata;
    }

    private void updateStatus(InfoMetadata infoMetadata, ModelInfo modelInfo) {
        Serializable[] serializableArray = new Serializable[infoMetadata.statusItemIds.length];
        int n = 0;
        while (n < serializableArray.length) {
            serializableArray[n] = modelInfo.get(infoMetadata.statusItemIds[n]);
            ++n;
        }
        StatusModelInfo statusModelInfo = (StatusModelInfo)this.getLocalStatus(null);
        statusModelInfo.add(infoMetadata.statusItemIds, serializableArray);
    }

    private void updateStatus(InfoMetadata infoMetadata, Vector vector, String string) {
        LocalTableStatus localTableStatus = (LocalTableStatus)this.getLocalStatus(string);
        int n = 0;
        while (n < vector.size()) {
            ModelInfo modelInfo = (ModelInfo)vector.elementAt(n);
            LocalModel localModel = this.getRowIfInMonitorRange(modelInfo);
            if (localModel != null) {
                if (localModel.statusType == 2) {
                    localModel.updateStatus(infoMetadata, modelInfo);
                }
                if (localTableStatus.isMonitored(modelInfo)) {
                    modelInfo.flagAsMonitored();
                } else {
                    modelInfo.flagAsNotMonitored();
                }
            }
            if (localTableStatus.isCritical(modelInfo)) {
                modelInfo.flagAsCritical();
            } else {
                modelInfo.flagAsNotCritical();
            }
            ++n;
        }
    }

    private void checkForStatus(Vector vector, String string) {
        LocalTableStatus localTableStatus = (LocalTableStatus)this.getLocalStatus(string);
        if (localTableStatus != null) {
            int n = 0;
            while (n < vector.size()) {
                ModelInfo modelInfo = (ModelInfo)vector.elementAt(n);
                if (localTableStatus.isMonitored(modelInfo)) {
                    modelInfo.flagAsMonitored();
                } else {
                    modelInfo.flagAsNotMonitored();
                }
                if (localTableStatus.isCritical(modelInfo)) {
                    modelInfo.flagAsCritical();
                } else {
                    modelInfo.flagAsNotCritical();
                }
                ++n;
            }
        }
    }

    private void checkForStatus(ModelInfo modelInfo, String string) {
        LocalTableStatus localTableStatus = (LocalTableStatus)this.getLocalStatus(string);
        if (localTableStatus != null) {
            if (localTableStatus.isMonitored(modelInfo)) {
                modelInfo.flagAsMonitored();
            } else {
                modelInfo.flagAsNotMonitored();
            }
            if (localTableStatus.isCritical(modelInfo)) {
                modelInfo.flagAsCritical();
                return;
            }
            modelInfo.flagAsNotCritical();
        }
    }

    public ModelInfo getInfo(String string) {
        ModelInfo modelInfo = new ModelInfo();
        InfoMetadata infoMetadata = this.getInfoMetadata(string);
        int n = 0;
        while (n < infoMetadata.itemIds.length) {
            modelInfo.add(infoMetadata.itemIds[n]);
            ++n;
        }
        this.instr.get(modelInfo, this, this.getIndexes(), this.context);
        if (infoMetadata.statusItemIds != null && (this.statusType == 1 || this.statusType == 2)) {
            this.updateStatus(infoMetadata, modelInfo);
        }
        return modelInfo;
    }

    public ModelInfo getInfo(String string, String string2, ModelInfo modelInfo) {
        int n;
        InfoMetadata infoMetadata = this.getInfoMetadata(string);
        ModelInfo modelInfo2 = new ModelInfo();
        String[] stringArray = this.instr.getIndexNames();
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                if (modelInfo.get(stringArray[n]) != null) {
                    modelInfo2.add(stringArray[n], modelInfo.get(stringArray[n]));
                }
                ++n;
            }
        }
        n = 0;
        while (n < infoMetadata.itemIds.length) {
            modelInfo2.add(infoMetadata.itemIds[n]);
            ++n;
        }
        if (this.localTableFilterItems != null) {
            int n2 = 0;
            while (n2 < this.localTableFilterItems.length) {
                if (modelInfo2.get(this.localTableFilterItems[n2]) == null) {
                    modelInfo2.add(this.localTableFilterItems[n2]);
                }
                ++n2;
            }
        }
        Serializable[] serializableArray = this.instr.getIndexFromInfo(modelInfo2);
        this.instr.get(modelInfo2, this, serializableArray, this.context);
        if (this.localTableFilter != null && !this.localTableFilter.pass(modelInfo2, this)) {
            return null;
        }
        if (this.statusType == 1 || this.statusType == 3) {
            if (infoMetadata.statusItemIds != null) {
                Vector<ModelInfo> vector = new Vector<ModelInfo>();
                vector.addElement(modelInfo2);
                this.updateStatus(infoMetadata, vector, string2);
            } else {
                this.checkForStatus(modelInfo2, string2);
            }
        } else if (this.statusType == 2 && infoMetadata.statusItemIds != null) {
            this.updateStatus(infoMetadata, modelInfo2);
        }
        return modelInfo2;
    }

    public ModelInfo setInfo(String string, ModelInfo modelInfo) {
        this.getInfoMetadata(string);
        Serializable[] serializableArray = this.instr.getIndexFromInfo(modelInfo);
        if (serializableArray == null) {
            serializableArray = this.getIndexes();
        }
        this.instr.set(modelInfo, this, serializableArray, this.context);
        return modelInfo;
    }

    public ModelInfo setInfo(String string, Vector vector) {
        this.getInfoMetadata(string);
        ModelInfo modelInfo = (ModelInfo)vector.lastElement();
        this.instr.set(vector, this, this.getIndexes(), this.context);
        return modelInfo;
    }

    public ModelInfo getNextInfo(String string, String string2, ModelInfo modelInfo) {
        return this.getNextInfo(string, string2, modelInfo, null);
    }

    public ModelInfo getNextInfo(String string, String string2, ModelInfo modelInfo, TableFilter tableFilter) {
        Object object;
        boolean bl;
        ModelInfo modelInfo2;
        ModelInfo modelInfo3;
        InfoMetadata infoMetadata;
        block22: {
            Object[] objectArray;
            block21: {
                if (this.isRow) {
                    return null;
                }
                infoMetadata = this.getInfoMetadata(string);
                modelInfo3 = null;
                modelInfo2 = new ModelInfo();
                bl = false;
                if (modelInfo != null) break block21;
                if (this.indexContext == null) break block22;
                objectArray = this.indexContext.getValues();
                object = this.instr.getIndexNames();
                int n = 0;
                while (n < objectArray.length) {
                    modelInfo2.add(object[n], (Serializable)objectArray[n]);
                    ++n;
                }
                if (objectArray.length != ((String[])object).length) break block22;
                bl = true;
                break block22;
            }
            objectArray = this.instr.getIndexNames();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    if (modelInfo.get((String)objectArray[n]) != null) {
                        modelInfo2.add((String)objectArray[n], modelInfo.get((String)objectArray[n]));
                    }
                    ++n;
                }
            }
        }
        int n = 0;
        while (n < infoMetadata.itemIds.length) {
            modelInfo2.add(infoMetadata.itemIds[n]);
            ++n;
        }
        if (this.localTableFilterItems != null) {
            int n2 = 0;
            while (n2 < this.localTableFilterItems.length) {
                if (modelInfo2.get(this.localTableFilterItems[n2]) == null) {
                    modelInfo2.add(this.localTableFilterItems[n2]);
                }
                ++n2;
            }
        }
        if (bl) {
            this.instr.get(modelInfo2, this, this.indexContext.getValues(), this.context);
            if (tableFilter != null && !tableFilter.pass(modelInfo2)) {
                modelInfo2 = null;
            }
            if (this.localTableFilter != null && !this.localTableFilter.pass(modelInfo2, this)) {
                modelInfo2 = null;
            }
            modelInfo3 = modelInfo2;
        } else {
            do {
                if ((modelInfo3 = this.instr.getNext(modelInfo2, this, this.context, tableFilter)) == null) {
                    return null;
                }
                if (!(this.getIndexOID() == null || (object = this.getRowID(modelInfo3)) != null && ((OID)object).startsWith(this.getIndexOID()))) {
                    return null;
                }
                if (this.localTableFilter == null || this.localTableFilter.pass(modelInfo3, this)) continue;
                modelInfo2 = modelInfo3;
                modelInfo3 = null;
            } while (modelInfo3 == null && this.localTableFilter != null);
        }
        if (this.statusType == 1 || this.statusType == 3) {
            if (infoMetadata.statusItemIds != null) {
                object = new Vector();
                ((Vector)object).addElement(modelInfo3);
                this.updateStatus(infoMetadata, (Vector)object, string2);
            } else {
                this.checkForStatus(modelInfo3, string2);
            }
        } else if (this.statusType == 2 && infoMetadata.statusItemIds != null) {
            this.updateStatus(infoMetadata, modelInfo3);
        }
        return modelInfo3;
    }

    public Vector getNextInfo(String string, String string2, ModelInfo modelInfo, int n) {
        return this.getNextInfo(string, string2, modelInfo, n, null);
    }

    public Vector getNextInfo(String string, String string2, ModelInfo modelInfo, int n, TableFilter tableFilter) {
        this.getInfoMetadata(string);
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        Vector<ModelInfo> vector = new Vector<ModelInfo>();
        int n2 = 0;
        ModelInfo modelInfo2 = modelInfo;
        do {
            modelInfo2 = this.getNextInfo(string, string2, modelInfo2, tableFilter);
            ++n2;
            if (modelInfo2 == null) continue;
            vector.addElement(modelInfo2);
        } while (modelInfo2 != null && !modelInfo2.timeoutDetected && (bl || n2 < n));
        return vector;
    }

    public Vector getRestOfInfo(String string, String string2, ModelInfo modelInfo, TableFilter tableFilter) {
        return this.getNextInfo(string, string2, modelInfo, 0, tableFilter);
    }

    public OID getRowID(ModelInfo modelInfo) {
        OID oID = null;
        try {
            oID = this.instr.getRowID(modelInfo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return oID;
    }

    public OID getRowID() {
        LocalModel localModel = this;
        synchronized (localModel) {
            if (this.rowID == null) {
                this.rowID = this.instr.getRowID(this.getIndexes());
            }
        }
        return this.rowID;
    }

    public LocalModel findRow(OID oID) {
        LocalModel localModel = null;
        if (this.rows != null) {
            localModel = (LocalModel)this.rows.getObject(oID);
        }
        return localModel;
    }

    public LocalModel getRowIfInMonitorRange(ModelInfo modelInfo) {
        if (modelInfo == null) {
            return null;
        }
        LocalModel localModel = null;
        OID oID = this.getRowID(modelInfo);
        if (oID == null) {
            return null;
        }
        if (this.getIndexOID() != null && !oID.startsWith(this.getIndexOID())) {
            return null;
        }
        int n = -1;
        boolean bl = false;
        LocalModel localModel2 = this;
        synchronized (localModel2) {
            if (this.rows == null) {
                this.rows = new Mib();
            }
            if ((n = this.rows.indexOf(oID)) == -1) {
                this.rows.setObject(oID, this);
                n = this.rows.indexOf(oID);
                this.rows.deleteObject(oID);
            }
        }
        int n2 = 0;
        Vector vector = this.getSchemes();
        int n3 = 0;
        while (n3 < vector.size()) {
            LocalTableStatus localTableStatus = (LocalTableStatus)vector.elementAt(n3);
            int n4 = localTableStatus.getMaxRows();
            if (n4 > n2) {
                n2 = n4;
            } else if (n4 == 0) {
                bl = localTableStatus.isMonitored(modelInfo);
            }
            ++n3;
        }
        if (bl || n < n2) {
            localModel = this.getRow(modelInfo);
        }
        return localModel;
    }

    public LocalModel getRow(ModelInfo modelInfo) {
        OID oID = this.getRowID(modelInfo);
        if (oID == null) {
            return null;
        }
        if (this.localTableFilterItems != null && !this.filterRogueModelInfo(modelInfo)) {
            return null;
        }
        return this.getRow(oID, this.instr.getIndexFromInfo(modelInfo));
    }

    public boolean filterRogueModelInfo(ModelInfo modelInfo) {
        boolean bl = false;
        int n = 0;
        while (n < this.localTableFilterItems.length) {
            if (modelInfo.get(this.localTableFilterItems[n]) == null) {
                bl = true;
                modelInfo.add(this.localTableFilterItems[n]);
            }
            ++n;
        }
        ModelInfo modelInfo2 = bl ? this.getInfo("_Empty", "default", modelInfo) : modelInfo;
        return modelInfo2 != null;
    }

    public LocalModel getRow(OID oID, Serializable[] serializableArray) {
        Object object;
        LocalModel localModel = null;
        boolean bl = false;
        if (oID == null) {
            return null;
        }
        if (oID != null) {
            object = this;
            synchronized (object) {
                if (this.rows == null) {
                    this.rows = new Mib();
                }
                if ((localModel = (LocalModel)this.rows.getObject(oID)) == null) {
                    int n = 0;
                    if (this.statusType == 3) {
                        n = 2;
                    }
                    new IndexContext(serializableArray, oID);
                    localModel = new LocalModel(this, new IndexContext(serializableArray, oID), n);
                    bl = true;
                    this.rows.setObject(oID, localModel);
                }
            }
        }
        if (bl && this.statusType == 3) {
            object = this.getSchemes();
            int n = 0;
            while (n < ((Vector)object).size()) {
                int n2;
                boolean bl2;
                LocalTableStatus localTableStatus = (LocalTableStatus)((Vector)object).elementAt(n);
                int n3 = localTableStatus.getMaxRows();
                if (this.rows.size() <= n3) {
                    Vector vector = localTableStatus.getRules();
                    bl2 = true;
                    if (vector != null) {
                        int n4 = 0;
                        while (bl2 && n4 < vector.size()) {
                            StatusRule statusRule = (StatusRule)vector.elementAt(n4);
                            bl2 = statusRule.evaluate(localModel);
                            ++n4;
                        }
                    }
                    if (bl2) {
                        StatusImpl statusImpl = (StatusImpl)((Object)localModel.getLocalStatus(localTableStatus.getSchemeId()));
                        localTableStatus.addDependent(statusImpl);
                        if (statusImpl instanceof LocalComponentStatus) {
                            ((LocalStatus)((Object)statusImpl)).startStatus();
                        }
                    }
                } else if (n3 != 0 && (n2 = this.rows.indexOf(oID)) < n3) {
                    bl2 = true;
                    Vector vector = localTableStatus.getRules();
                    if (vector != null) {
                        int n5 = 0;
                        while (bl2 && n5 < vector.size()) {
                            StatusRule statusRule = (StatusRule)vector.elementAt(n5);
                            bl2 = statusRule.evaluate(localModel);
                            ++n5;
                        }
                    }
                    if (bl2) {
                        StatusImpl statusImpl = (StatusImpl)((Object)localModel.getLocalStatus(localTableStatus.getSchemeId()));
                        localTableStatus.addDependent(statusImpl);
                        if (statusImpl instanceof LocalComponentStatus) {
                            ((LocalStatus)((Object)statusImpl)).startStatus();
                        }
                    }
                    if (this.rows.size() >= n3 + 1) {
                        this.instr.stopStatusForRow(this.rows.getOidAt(n3), (CompoundStatus)localTableStatus, this, true);
                    }
                }
                ++n;
            }
        }
        return localModel;
    }

    public CreateResponse createNewRow(ModelInfo modelInfo) {
        CreateResponse createResponse = null;
        try {
            ModelclassMetadata modelclassMetadata = (ModelclassMetadata)this.instr.metadataPool.get("_Class_");
            createResponse = modelclassMetadata.createDelete ? this.instr.createNewRow(modelInfo, this, this.context) : new CreateResponse(6, modelInfo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return createResponse;
    }

    public DeleteResponse deleteExistingRow(ModelInfo modelInfo) {
        DeleteResponse deleteResponse = null;
        try {
            ModelclassMetadata modelclassMetadata = (ModelclassMetadata)this.instr.metadataPool.get("_Class_");
            deleteResponse = modelclassMetadata.createDelete ? this.instr.deleteExistingRow(modelInfo, this, this.context) : new DeleteResponse(6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return deleteResponse;
    }

    public int evaluate2(String string) {
        int n = 0;
        try {
            if (this.instr instanceof SnmpInstrumentation) {
                n = ((SnmpInstrumentation)this.instr).evaluate2(string, this.getIndexOID(), this.context, this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public boolean evaluate(String string) {
        boolean bl = false;
        try {
            bl = this.instr.evaluate(string, this.getIndexOID(), this.context, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public void startStatus() {
        try {
            dispatchQueue.post((DispatchMessage)new StartMonitorRequest(this));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void stopStatus() {
        try {
            dispatchQueue.post((DispatchMessage)new StopMonitorRequest(this));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void refreshStatus() {
        try {
            dispatchQueue.post((DispatchMessage)new RefreshMonitorRequest(this));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void startStatusTable() {
        try {
            dispatchQueue.post((DispatchMessage)new StartTableMonitorRequest(this));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void stopStatusTable() {
        try {
            dispatchQueue.post((DispatchMessage)new StopTableMonitorRequest(this));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void refreshStatusTable() {
        try {
            dispatchQueue.post((DispatchMessage)new RefreshTableMonitorRequest(this));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void dispose() {
        try {
            LocalModel localModel = this;
            synchronized (localModel) {
                if (!this.disposed) {
                    InstrumentationContext instrumentationContext;
                    this.disposed = true;
                    dispatchQueue.post((DispatchMessage)new DisposeRequest(this, false));
                    if (this.getTopLevel() == this && this.getContext() != null && (instrumentationContext = this.getContext()) instanceof SnmpInstrContext) {
                        SnmpSession snmpSession = ((SnmpInstrContext)instrumentationContext).getSession();
                        snmpSession.removeAddressChangeListener((AddressChangeListener)this);
                    }
                    this.deregisterTraps();
                }
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void deregisterTraps() {
        if (this.trapRules != null) {
            TrapService trapService = (TrapService)JdmServerImpl.getSingleton().getService((Object)"TrapService");
            if (trapService != null) {
                Enumeration enumeration = this.trapRules.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    System.out.println("Deregistering trap: " + string + " because local model is deleted");
                    try {
                        trapService.deleteRule(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return;
            }
            System.out.println("Unable to find local trap service in LocalModel; traps not deregistered");
        }
    }

    public void reallyDispose() {
        try {
            LocalModel localModel = this;
            synchronized (localModel) {
                if (!this.disposed) {
                    this.disposed = true;
                    dispatchQueue.post((DispatchMessage)new DisposeRequest(this, true));
                    this.deregisterTraps();
                }
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void packageResults(LocalModel localModel, Object[] objectArray, Object[] objectArray2, long l) {
        try {
            this.instr.packageResults(localModel, objectArray, objectArray2, l, false);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void packageTableResults(Vector vector, Vector vector2, Vector vector3, long l) {
        try {
            this.instr.packageTableResults(this, vector, vector2, vector3, l);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void savePersistentInfo(String string, Serializable serializable) {
        String string2 = this.instr.getClass().getName();
        String string3 = "";
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            String string4 = stringTokenizer.nextToken();
            if (!(string4.equals("ibm") || string4.equals("nways") || string4.equals("model"))) {
                if (string4.endsWith("SnmpInstr")) {
                    string4 = string4.substring(0, string4.length() - 9);
                    if (!bl) {
                        string3 = String.valueOf(string3) + ".";
                    }
                    bl = false;
                    string3 = String.valueOf(string3) + string4;
                } else {
                    if (!bl) {
                        string3 = String.valueOf(string3) + ".";
                    }
                    bl = false;
                    string3 = String.valueOf(string3) + string4;
                }
            }
            ++n2;
        }
        if (!bl) {
            string3 = String.valueOf(string3) + ".";
        }
        string3 = String.valueOf(string3) + string;
        this.context.savePersistentInfo(string3, serializable);
    }

    public Serializable getPersistentInfo(String string) {
        String string2 = this.instr.getClass().getName();
        String string3 = "";
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            String string4 = stringTokenizer.nextToken();
            if (!(string4.equals("ibm") || string4.equals("nways") || string4.equals("model"))) {
                if (string4.endsWith("SnmpInstr")) {
                    string4 = string4.substring(0, string4.length() - 9);
                    if (!bl) {
                        string3 = String.valueOf(string3) + ".";
                    }
                    bl = false;
                    string3 = String.valueOf(string3) + string4;
                } else {
                    if (!bl) {
                        string3 = String.valueOf(string3) + ".";
                    }
                    bl = false;
                    string3 = String.valueOf(string3) + string4;
                }
            }
            ++n2;
        }
        if (!bl) {
            string3 = String.valueOf(string3) + ".";
        }
        string3 = String.valueOf(string3) + string;
        return this.context.getPersistentInfo(string3);
    }

    public void startStatusForRow(OID oID, CompoundStatus compoundStatus, boolean bl) {
        try {
            this.instr.startStatusForRow(oID, compoundStatus, this, bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void stopStatusForRow(OID oID, CompoundStatus compoundStatus, boolean bl) {
        try {
            this.instr.stopStatusForRow(oID, compoundStatus, this, bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected void adjustNumberOfStatusRows(LocalTableStatus localTableStatus, int n, int n2) {
        this.instr.adjustNumberOfStatusRows(localTableStatus, this, n, n2);
    }

    public void addStatusComponent(String string) {
        Vector vector = this.getSchemes();
        int n = 0;
        while (n < vector.size()) {
            LocalComponentStatus localComponentStatus = (LocalComponentStatus)vector.elementAt(n);
            localComponentStatus.addComponent(string);
            ++n;
        }
    }

    public void removeStatusComponent(String string) {
        Vector vector = this.getSchemes();
        int n = 0;
        while (n < vector.size()) {
            LocalComponentStatus localComponentStatus = (LocalComponentStatus)vector.elementAt(n);
            localComponentStatus.removeComponent(string);
            ++n;
        }
    }

    protected void finalize() throws Throwable {
        this.context = null;
        this.rows = null;
        this.indexContext = null;
        if (this.schemes != null) {
            this.schemes.removeAllElements();
        }
        this.schemes = null;
        this.rowID = null;
        this.remoteModel = null;
        this.toplevel = null;
        this.status = null;
        this.specialSMI = null;
        if (this.components != null) {
            this.components.clear();
        }
        this.components = null;
    }

    public Vector getComponentNames() {
        Vector<String> vector = new Vector<String>();
        ModelclassMetadata modelclassMetadata = (ModelclassMetadata)this.instr.metadataPool.get("_Class_");
        Enumeration enumeration = this.instr.metadataPool.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("_COMPONENT.")) continue;
            ComponentMetadata componentMetadata = (ComponentMetadata)this.instr.metadataPool.get(string);
            String string2 = string.substring(11);
            if (this.isRow && componentMetadata.appliesToRows) {
                vector.addElement(string2);
                continue;
            }
            if (this.isRow || componentMetadata.appliesToRows && modelclassMetadata.isVector) continue;
            vector.addElement(string2);
        }
        return vector;
    }

    public Vector getInfoNames() {
        Vector<String> vector = new Vector<String>();
        ModelclassMetadata cfr_ignored_0 = (ModelclassMetadata)this.instr.metadataPool.get("_Class_");
        Enumeration enumeration = this.instr.metadataPool.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("_INFO.")) continue;
            InfoMetadata infoMetadata = (InfoMetadata)this.instr.metadataPool.get(string);
            String string2 = string.substring(6);
            if (string2.equals("_Empty")) continue;
            if (this.isRow && infoMetadata.isVector) {
                vector.addElement(string2);
                continue;
            }
            if (this.isRow || infoMetadata.isVector) continue;
            vector.addElement(string2);
        }
        return vector;
    }

    public Vector getRowIDs() {
        ModelclassMetadata modelclassMetadata = (ModelclassMetadata)this.instr.metadataPool.get("_Class_");
        if (modelclassMetadata.isVector) {
            Vector<String> vector = new Vector<String>();
            Vector vector2 = this.getRestOfInfo("_Empty", "default", null, null);
            if (vector2 == null) {
                return null;
            }
            int n = 0;
            while (n < vector2.size()) {
                ModelInfo modelInfo = (ModelInfo)vector2.elementAt(n);
                OID oID = this.getRowID(modelInfo);
                vector.addElement(oID.toString());
                ++n;
            }
            return vector;
        }
        return null;
    }

    class ConfigDetectorInitRequest
    implements DispatchMessage {
        String configDetector;
        LocalModel locmod;

        public ConfigDetectorInitRequest(String string, LocalModel localModel2) {
            LocalModel.this = LocalModel.this;
            this.configDetector = string;
            this.locmod = localModel2;
        }

        public int getPriority() {
            return 3;
        }

        public void dispatch() {
            try {
                Class<?> clazz = Class.forName(this.configDetector);
                LocalModel.this.detector = (ConfigChangeDetector)clazz.newInstance();
                LocalModel.this.detector.init(this.locmod);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LocalModel.this.detector = null;
                return;
            }
        }
    }
}

